/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.misc;

import dev.latvian.mods.kubejs.misc.MobEffectBuilder;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.script.ScriptType;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1291;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_2960;
import net.minecraft.class_5131;
import org.jetbrains.annotations.NotNull;

public class BasicMobEffect
extends class_1291 {
    private final MobEffectBuilder.EffectTickCallback effectTickCallback;
    private final Map<class_2960, class_1322> modifierMap;
    private final Map<class_1320, class_1322> attributeMap;
    private boolean modified = false;
    private final class_2960 id;

    public BasicMobEffect(Builder builder) {
        super(builder.category, builder.color);
        this.effectTickCallback = builder.effectTick;
        this.modifierMap = builder.attributeModifiers;
        this.attributeMap = new HashMap<class_1320, class_1322>();
        this.id = builder.id;
    }

    public void method_5572(@NotNull class_1309 livingEntity, int i) {
        try {
            this.effectTickCallback.applyEffectTick(livingEntity, i);
        }
        catch (Throwable e) {
            ScriptType.STARTUP.console.error("Error while ticking mob effect " + this.id + " for entity " + livingEntity.method_5477().getString(), e);
        }
    }

    private void applyAttributeModifications() {
        if (!this.modified) {
            this.modifierMap.forEach((r, m) -> this.attributeMap.put(RegistryInfo.ATTRIBUTE.getValue((class_2960)r), (class_1322)m));
            this.modified = true;
        }
    }

    public Map<class_1320, class_1322> method_5565() {
        this.applyAttributeModifications();
        return this.attributeMap;
    }

    public void method_5562(class_1309 livingEntity, class_5131 attributeMap, int i) {
        this.applyAttributeModifications();
        for (Map.Entry<class_1320, class_1322> entry : this.attributeMap.entrySet()) {
            class_1324 attributeInstance = attributeMap.method_26842(entry.getKey());
            if (attributeInstance == null) continue;
            attributeInstance.method_6202(entry.getValue());
        }
    }

    public void method_5555(class_1309 livingEntity, class_5131 attributeMap, int i) {
        this.applyAttributeModifications();
        for (Map.Entry<class_1320, class_1322> attributeAttributeModifierEntry : this.attributeMap.entrySet()) {
            class_1324 attributeInstance = attributeMap.method_26842(attributeAttributeModifierEntry.getKey());
            if (attributeInstance == null) continue;
            class_1322 attributeModifier = attributeAttributeModifierEntry.getValue();
            attributeInstance.method_6202(attributeModifier);
            attributeInstance.method_26837(new class_1322(attributeModifier.method_6189(), this.method_5567() + " " + i, this.method_5563(i, attributeModifier), attributeModifier.method_6182()));
        }
    }

    public boolean method_5552(int i, int j) {
        return this.effectTickCallback != null;
    }

    public static class Builder
    extends MobEffectBuilder {
        public Builder(class_2960 i) {
            super(i);
        }

        @Override
        public class_1291 createObject() {
            return new BasicMobEffect(this);
        }
    }
}

